# Arduino UNO R4 WiFi Clock

Arduino UNO R4 WiFiを使用したNTP時計プロジェクトです。WiFi経由でインターネット時刻サーバー(NTP)から正確な時刻を取得し、シリアルモニターに表示します。

## 必要なもの

### ハードウェア
- Arduino UNO R4 WiFi

### ソフトウェア
- Arduino IDE (最新版推奨)
- 必要なライブラリ:
  - WiFiS3 (Arduino UNO R4 WiFi標準搭載)
  - NTPClient

## ライブラリのインストール

1. Arduino IDEを開く
2. メニューから「スケッチ」→「ライブラリをインクルード」→「ライブラリを管理...」を選択
3. ライブラリマネージャーで「NTPClient」を検索
4. **NTPClient by Fabrice Weinberg** をインストール

## 使い方

### 1. WiFi設定の変更

[uno_r4_clock.ino](uno_r4_clock.ino) を開き、以下の部分を自分のWiFi情報に変更してください:

```cpp
const char* SSID = "YOUR_WIFI_SSID";      // WiFiのSSID
const char* PASSWORD = "YOUR_WIFI_PASSWORD";  // WiFiのパスワード
```

### 2. タイムゾーンの設定

デフォルトは日本標準時(JST = GMT+9)に設定されています。他の地域の場合は変更してください:

```cpp
const long GMT_OFFSET_SEC = 32400;  // 秒単位で指定(9時間 = 9 * 3600)
```

主要なタイムゾーン:
- JST (日本): 32400 (GMT+9)
- PST (太平洋標準時): -28800 (GMT-8)
- EST (東部標準時): -18000 (GMT-5)
- UTC (協定世界時): 0

### 3. アップロードと実行

1. Arduino UNO R4 WiFiをUSBケーブルでPCに接続
2. Arduino IDEで「ツール」→「ボード」から「Arduino UNO R4 WiFi」を選択
3. 「ツール」→「ポート」から適切なCOMポートを選択
4. 「アップロード」ボタンをクリック
5. アップロード完了後、「シリアルモニター」を開く(ボーレート: 115200)

## 表示例

```
=== Arduino UNO R4 WiFi Clock ===
WiFi接続中...
...
WiFi接続成功!
IPアドレス: 192.168.1.100
NTPサーバーから時刻を取得中...
時刻取得完了!

2025年01月24日(金) 14:30:45
```

時刻は1秒ごとに自動更新されます。

## 機能

- WiFi経由でNTPサーバーから時刻を自動取得
- 年月日と曜日の表示
- 時分秒の表示(24時間形式)
- 1秒ごとの自動更新
- WiFi接続断時の自動再接続

## トラブルシューティング

### WiFi接続失敗
- SSID と PASSWORD が正しいか確認
- WiFiルーターの2.4GHz帯を使用しているか確認(5GHzは非対応)
- WiFiルーターの設定でデバイス制限がないか確認

### 時刻が表示されない
- シリアルモニターのボーレートが115200になっているか確認
- インターネット接続が正常か確認

### 時刻がずれている
- GMT_OFFSET_SEC の設定を確認
- NTPサーバーへのアクセスが制限されていないか確認

## カスタマイズ

### 表示フォーマットの変更
`loop()` 関数内の表示部分を編集することで、時刻の表示形式を自由に変更できます。

### 12時間形式への変更例
```cpp
int displayHours = hours;
const char* ampm = "AM";
if (hours >= 12) {
  ampm = "PM";
  if (hours > 12) displayHours = hours - 12;
} else if (hours == 0) {
  displayHours = 12;
}
```

### LCDディスプレイへの出力
I2C LCDなどのディスプレイを追加することで、スタンドアロンの時計として使用できます。

## ライセンス

このプロジェクトはオープンソースです。自由に改変・使用してください。
